#!/usr/local/bin/perl

sub add_data {
	
	my($my_sth, $field_info, @boxes, $prim_exists);

	print &html("Add Data");
	print "$form_method\n";
	print "<INPUT TYPE=\"HIDDEN\" NAME=\"table\" VALUE=\"$table\">\n";
	print "<INPUT TYPE=\"HIDDEN\" NAME=\"action\" VALUE=\"add_data_final\">\n";
	print "<table border=1>\n";
	print "<tr bgcolor=\"#c0e0a0\">";
	
	$my_sth = $dbh->ListFields($table);
	for (0..$my_sth->numfields-1) {
		
		$field_info  = &sqltype($my_sth->type->[$_]);
		if ($field_info eq "CHAR") {
			$field_info .= "(".$my_sth->length->[$_].")";
			if ($my_sth->length->[$_] < 31) {
				$boxes[$_] = "\t<td><INPUT TYPE=\"TEXT\" NAME=\"$_\" VALUE=\"\" SIZE=\"".$my_sth->length->[$_]."\" MAXLENGTH=\"".$my_sth->length->[$_]."\"></td>\n";
			} else {
				$boxes[$_] = "\t<td><INPUT TYPE=\"TEXT\" NAME=\"$_\" VALUE=\"\" SIZE=\"30\" MAXLENGTH=\"".$my_sth->length->[$_]."\"></td>\n";
			}
		}  else {
			$boxes[$_] = "\t<td><INPUT TYPE=\"TEXT\" NAME=\"$_\" VALUE=\"\" SIZE=\"10\" MAXLENGTH=\"20\"></td>\n";
		}
		
		$prim_exists .= &primary($my_sth->is_pri_key->[$_]);
		$field_info  = $my_sth->name->[$_].&primary($my_sth->is_pri_key->[$_])."<br><font size=2> $field_info </font>";
		print "\t<td><FONT SIZE=2><b><center>$field_info</b></font></center></td>\n";
		
	}

	print "\n</tr>\n";
	print "<tr>\n";
	for (0..$#boxes) {
		print $boxes[$_];
	}
	
	print "</tr>\n</table>";
	print "<FONT SIZE=2><b>* Primary Key. Values in this field must be unique for all records in this table.</b></font>" if $prim_exists;
	print "
		<hr>
		<center>
		<INPUT TYPE=\"SUBMIT\" NAME=\"Button\" VALUE=\"Insert Row\">
		<INPUT TYPE=\"reset\" VALUE=\"Clear\">
		</form>
		</center>";

	print &html_bot;
	return 1;
}

sub add_row {
	
	my($my_sth, @values, $todo, $err, $temp);
	my($ins_sql) = &sql_insert_stmt($table);

	$my_sth = $dbh->ListFields($table);
	#validate data
	
	for (0..$my_sth->numfields - 1) {
		
		$temp = $in{"$_"}; 

		if ($temp) {
			$todo = 1;
			
			if ($field_type[$_] == 1) {
				#integer field, must be a number
				$err .= "<li>Field ". $my_sth->name->[$_] . " must be an integer number.</li>" if $temp =~ /\D/;
			
			} elsif ($field_type[$_] == 2) {
				#character
				
			} elsif ($field_type[$_] == 3) {
				$err .= "<li>Field ". $my_sth->name->[$_] . " must be a Real number.</li>" unless &isReal($temp);

			} else {
				$err .= "<li>Unknown Data Type for field ".$my_sth->name->[$_]."</li>";
			}

			if ($field_type[$_] == 2) {
				$temp =~ s/\'/$quote_rep/eg;
				$temp = "\'$temp\'";
			}
			$ins_sql .= "$temp , ";

		} else {
			$ins_sql .= " 0," unless $field_type[$_] == 2;
			$ins_sql .= "\'\'," if $field_type[$_] == 2;
		}
	}
	
	&print_error("The following errors were found in the row.<ul>$err</ul>") if $err;
	&print_error("Nothing to do!") unless $todo;
	$ins_sql = &remove_last_comma($ins_sql).")";
	$my_sth = $dbh->Query($ins_sql) or &print_error("INSERT Statement Failed!<pre>Statement:<br>$ins_sql<br>Probably because you are trying to insert a row with a primary key value already in the database.<br>Make sure that the value you supply for the primary key Field is not the same with any existitng values for that field already in the database.</pre>");
	
	print &html("Insert Data");
	print "Row Inserted sucessfully.";
	print &html_bot;
	return 1;
}

sub change_name {
	
	my ($drop_old_table)=@_;
	my ($oldRows, $err, $newRows, $sth_hold); 
	my ($numFields, $sql, $i, $sth, $sql, $ins_sql);
	local(@arr);
	
	if ($table eq "") {	
		&print_error("Please select the table to back up.") if $this_action eq "backup_table";
		&print_error("Please select the table to rename.") if $this_action eq "change_name";
	}
	
	&print_error("Can\'t rename table <i><b>$table</i></b>. It is included in the protected tables.") if $excluded_tables =~ /,$table,/;
	&get_new_table_name unless $new_table_name;
    
#***check to have a valid new name
	&check_table_name($new_table_name);

#***create table, same structure, new name
	$sql = &SQLCreate($table);
	$sql = "CREATE TABLE $new_table_name \($sql\)\n";
	$sth = $dbh->Query($sql) or &print_error("CREATE TABLE Command Failed!<br><pre>$sql</pre>");
	

#***insert data from old table to new one
	$sth_hold = $dbh->Query(&SQLSelect($table)) or &print_error("SELECT Command Failed!");
	$sql = &sql_insert_stmt($new_table_name);
	$numFields = &table_field_count($new_table_name);

	while(@arr = $sth_hold->FetchRow) {
		#print "Array values: $arr[0] , $arr[1]";
		&insert_from_array(*arr, $sql, $numFields - 1);
	}

#***make sure all rows were inserted
	$sth = $dbh->Query(&SQLSelect($table)) or &print_error("SELECT Command Failed!<br><pre>$sql</pre>");
	$oldRows = $sth->numrows;
	
	$sth = $dbh->Query(&SQLSelect($new_table_name)) or 	&print_error("SELECT Command Failed!<br><pre>$sql</pre>");
    $newRows = $sth->numrows;

	if ($newRows != $oldRows) {
		$err  = "Problem: # of Rows in $table is not the same with # of Rows in $new_table_name<br>";
		$err .= "# of Rows In New Table: $newRows<br>";
		$err .= "# of Rows In Old Table: $oldRows<br>";
		$err .= "Aborting Operation";
		&drop_table_final($new_table_name);
		$sth = $dbh->Query($sql);
		&print_error($err);
		exit;
	}

#***drop old table, if drop flag is on
	&drop_table_final($table) if $drop_old_table;
	
	if ($this_action eq "backup_table") {
		print &html("Table Back Up");
		print "Table <i>$table</i> was backed up to <i>$new_table_name</i> sucessfully.";
		print "Process:<ol>";
		print "<li>Table <i>$new_table_name</i> was created.</li>";
		print "<li>All data from <i>$table</i> was copied into <i>$new_table_name</i>.</li>";
		print "<li>$newRows rows of data exist in both tables.</li>";
	
	} elsif ($this_action eq "change_name") {
		print &html ("Rename Table");
		print "Table <i>$table</i> was renamed to <i>$new_table_name</i> sucessfully.";
	}
	
	print &html_bot;
	return 1;

}

sub create_table {
	
	my($sql, $sth);
	&check_table_name($table);

#***Validate new fields
	&check_new_fields($new_table_fields_count);
	
#***Get the create table sql
	$sql .= &SQLCreate_new_fields($new_fields_count);
    $sql = "CREATE TABLE $table \($sql\)\n";

#***Create the table
	$sth = $dbh->Query($sql) or &print_error("CREATE TABLE Command Failed!<br><pre>$sql</pre>");

	print &html("Create Table");
	print "Table <i>$table</i> created.";
	print &html_bot;
	return 1;

}

sub query_table {

	my($my_sth, $field_info, $operator);
	&print_error("Please select the table to query.") unless $table;
	print &html;
	print "	$form_method
			<INPUT TYPE=\"HIDDEN\" NAME=\"table\" VALUE=\"$table\">
			<INPUT TYPE=\"HIDDEN\" NAME=\"action\" VALUE=\"$in{'action'}_final\">
			$query_tips
			Build The query using the layout below:<br>
			<table border = 0>
				<tr valign = top>
				<td valign = top>
				<table border = 0>
					<tr>
						<td valign=top><b>&nbsp;SELECT&nbsp;</b></td><td valign=top>";
	
	$my_sth = $dbh->ListFields($table);
	print "\n<td valign=top><SELECT MULTIPLE SIZE = ". $my_sth->numfields ." NAME=\"fields\">";
	$field_info = "<table border = 0 cellpadding = 0 cellspacing = 0>";
	
	for (0..$my_sth->numfields - 1) {
		print "\n\t<OPTION VALUE=\"".$my_sth->name->[$_]."\">".$my_sth->name->[$_];
		$field_info .= "<tr><td>".$my_sth->name->[$_]."</td>";
		if (&char_type($my_sth->type->[$_])) {
			$operator = $char_type_equality; 
		} else {
			$operator = $number_type_equality;
		}
	    $operator =~ s/#/$_/eg;
		$field_info .= "<td>&nbsp; $operator &nbsp;</td><td><INPUT TYPE=\"TEXT\" NAME=\"$_\"></td></tr>\n";
	}
	
	$field_info .= "</table>\n";
	print "\n</SELECT></td>\n";
	print "	<td valign=top><b>&nbsp;FROM $table WHERE&nbsp;</b></td>
			</tr></table>
			<td valign=top>$field_info</td></tr></table>
			<hr>
			<center>
			<INPUT TYPE=\"SUBMIT\" NAME=\"Button\" VALUE=\"Get Data\">
			<INPUT TYPE=\"reset\" VALUE=\"Clear\">
			</form>
			</center>";
	print &html_bot;
	return 1;
}



sub query_table_results {
	
	my $sql;
	my $where_clause_count = 0;
	my $where_clause = '';
	my $sth = $dbh->ListFields($table);
	my $field_count = $sth->numfields;
	my $op;
	my $val;

	print &html;
	$sql = $in{'fields'};
	$sql =~ s/\|/,/g;
	$sql = " * " unless $sql; #assume all fields if nothing is selected
	$sql = "SELECT $sql FROM $table ";
		
	for (0..$field_count) {
		if ($in{"eq$_"}) {
			$op = $in{"eq$_"};
			$op =~ s/gt/>/;
			$op =~ s/lt/</;
			$val = $in{"$_"};
			$val = "\Q$val\E";

			if (not $where_clause_count) {
				$where_clause .= " WHERE ".$sth->name->[$_]. " $op";
			} else {
				$where_clause .= " AND ".$sth->name->[$_]. " $op";
			}
			$where_clause_count++;
			if (&char_type($sth->type->[$_])) {
				$where_clause .= " \'$val\'";
			} else {
				if ($val) {
					$where_clause .= " $val";
				} else {
					$where_clause .= " 0";
				}
			}
		}
	}
	
	$sql .=	$where_clause;
	print "SELECT Statement Submitted: <b>$sql</b>";
	$rows = &print_sql_results($sql);
	$rows = "No " unless $rows;
	print "<br>$rows row(s) returned from statement.";
	print &html_bot;
}
1;
